#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;

#endregion

namespace RevitAddinWallLinkedModel
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;
            try
            {
                //I
                Wall selectedWall = null;
                //ǂhLg
                Document elementDoc = doc;
                // ǂI܂ŌJԂ
                while (selectedWall == null)
                {
                    try
                    {
                        // vfIBNꂽvfɂ̓tB^[gȂ
                        Reference myRef = uidoc.Selection.PickObject(ObjectType.LinkedElement,
                            "NĂ錚zfǂIĂBLZɂESC܂");
                        // Iꂽvfp̕ϐ錾
                        Element selectElement = null;
                        // NꂽvfH
                        if (myRef.LinkedElementId != ElementId.InvalidElementId)
                        {
                            // NCX^X擾
                            RevitLinkInstance linkInstance = doc.GetElement(myRef.ElementId) as RevitLinkInstance;
                            if (linkInstance != null)
                            {
                                // NCX^XĂ郊NhLg擾
                                Document linkedDoc = linkInstance.GetLinkDocument();
                                if (linkedDoc != null)
                                {
                                    //NhLgvf擾
                                    selectElement = linkedDoc.GetElement(myRef.LinkedElementId);
                                    elementDoc = linkedDoc;

                                    //LœꂽselectElementnullłȂƂmF
                                    if (selectElement != null)
                                    {
                                        // nullł͂Ȃ̂ŁAǂǂ`FbNBWallɃLXg݂
                                        selectedWall = selectElement as Wall;
                                        if (selectedWall == null)//ǂƂĂ͔FȂꍇ
                                        {
                                            // Nf̗vfAǈȊOIꂽꍇAĎs𑣂
                                            TaskDialogResult retryResult = TaskDialog.Show("IG[",
                                                $"Iꂽvf͕ǂł͂܂B\n" +
                                                $"Iꂽvf̃JeS: {selectElement.Category.Name}\n\n" +
                                                $"ǂI܂H",
                                                TaskDialogCommonButtons.Yes | TaskDialogCommonButtons.No);

                                            if (retryResult == TaskDialogResult.Yes)
                                            {
                                                continue; // Yes̏ꍇwhile[vp
                                            }
                                            else
                                            {
                                                return Result.Cancelled;
                                            }
                                        }
                                    }
                                    else
                                    {
                                        TaskDialog.Show("G[", "Iꂽvf擾ł܂łBēxNf̕ǂIĂB");
                                        continue;
                                    }
                                }
                            }
                            else
                            {
                                TaskDialog.Show("G[", "Iꂽvf̓NCX^Xł͂܂BēxNf̕ǂIĂB");
                                continue;
                            }
                        }
                    }
                    catch (Autodesk.Revit.Exceptions.OperationCanceledException)
                    {
                        return Result.Cancelled;
                    }
                } //while[v̏I

                // ǂ̏擾
                string familyName = selectedWall.WallType.FamilyName;
                string typeName = selectedWall.WallType.Name;
                string categoryName = selectedWall.Category.Name;

                // ʂ\
                TaskDialog.Show("Iꂽ",
                    $"{elementDoc.Title}\n" +
                    $"vfJeS: {categoryName}\n" +
                    $"t@~: {familyName}\n" +
                    $"^Cv: {typeName}");

                return Result.Succeeded;
            }
            catch (Exception ex)
            {
                message = $"G[܂: {ex.Message}";
                return Result.Failed;
            }
        }
    }
}
