#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using static Autodesk.Revit.DB.SpecTypeId;

#endregion

namespace RevitAddinWallHeight2
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;

            try
            {
                // ItB^[ݒ
                WallSelectionFilter filter = new WallSelectionFilter(doc);

                // tB^[tŃ[U[ɕǃCX^XIĂ炤
                Autodesk.Revit.DB.Reference myRef = uidoc.Selection.PickObject(ObjectType.Element, filter, "ǂIĂBLZɂESC܂");

                // Iꂽvf擾
                Element selectElement = doc.GetElement(myRef);

                // t@~A^CvAJeS擾
                Wall wall = selectElement as Wall;
                string familyName = wall.WallType.FamilyName;
                string typeName = wall.WallType.Name;
                string categeryName = selectElement.Category.Name;

                //ǂ̍擾
                string heightStr = GetParameter(wall, "w荂");
                //heightStrnull܂͋łȂmF
                if (!string.IsNullOrEmpty(heightStr))
                {
                    // heightStrlɕϊł邩mF
                    if (double.TryParse(heightStr, out double height))
                    {
                        //Pʂ~[gɕϊ
                        double heightInMM = (int)Math.Round(UnitUtils.ConvertFromInternalUnits(height, UnitTypeId.Millimeters), 0);
                        // ʂ\
                        TaskDialog.Show("ǂ̏",
                            $"ǂ̍: {heightInMM}\n" +
                            $"t@~: {familyName} / " +
                            $"^Cv: {typeName}");
                        return Result.Succeeded;
                    }
                    else
                    {
                        // lϊɎsꍇ
                        message = $"Ǎlɕϊł܂łB";
                        return Result.Failed;
                    }
                }
                else
                {
                    // uheightStrnull܂͋v=p[^Ȃꍇ
                    message = $"ǂ́uw荂vp[^܂łB";
                    return Result.Failed;
                }
            }
            catch (Autodesk.Revit.Exceptions.OperationCanceledException)
            {
                // [U[LZꍇ
                return Result.Cancelled;
            }
            catch (Exception ex)
            {
                // ̑̃G[ꍇ
                message = $"G[܂: {ex.Message}";
                return Result.Failed;
            }
        }
        private static string ParameterToString(Parameter param)
        {
            string val = "none";
            if (param == null)
            {
                return val;
            }
            switch (param.StorageType)
            {
                case StorageType.Double:
                    double dVal = param.AsDouble();
                    val = dVal.ToString();
                    break;
                case StorageType.Integer:
                    int iVal = param.AsInteger();
                    val = iVal.ToString();
                    break;
                case StorageType.String:
                    string sVal = param.AsString();
                    //nullȂAsValueStringœǂł݂
                    if (sVal == null) sVal = param.AsValueString();
                    val = sVal;
                    break;
                case StorageType.ElementId:
                    ElementId idVal = param.AsElementId();
                    val = idVal.ToString();
                    break;
                case StorageType.None:
                    break;
                default:
                    break;
            }
            return val;
        }
        //vf̎wp[^P擾
        private string GetParameter(Element elem, string paramName)
        {
            string result = null;
            foreach (Parameter param in elem.GetOrderedParameters())
            {
                string name = param.Definition.Name;
                if (name.Equals(paramName))
                {
                    result = ParameterToString(param);
                    break;
                }
            }
            return result;
        }
    }

    public class WallSelectionFilter : ISelectionFilter
    {
        private readonly Document doc;
        //RXgN^
        public WallSelectionFilter(Document doc)
        {
            this.doc = doc;
        }
        //vf̑I邩ǂ̃\bh
        public bool AllowElement(Element elem)
        {
            if (elem is Autodesk.Revit.DB.Wall)
            {
                return true;
            }

            return false;
        }
        //vf̖ʂGbWȂǃWIgւ̎QƂIł邩ǂ̃\bh
        public bool AllowReference(Autodesk.Revit.DB.Reference reference, XYZ position)
        {
            return false;
        }
    }
}