#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;

#endregion

namespace RevitAddinWall3
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;

            try
            {
                // ItB^[ݒ
                WallSelectionFilter filter = new WallSelectionFilter(doc);

                // tB^[tŃ[U[ɕǃCX^XIĂ炤
                Reference myRef = uidoc.Selection.PickObject(ObjectType.Element, filter, "ǂIĂBLZɂESC܂");

                // Iꂽvf擾
                Element selectElement = doc.GetElement(myRef);

                // t@~A^CvAJeS擾
                Wall wall = selectElement as Wall;
                string familyName = wall.WallType.FamilyName;
                string typeName = wall.WallType.Name;
                string categeryName = selectElement.Category.Name;
                

                // ʂ\
                TaskDialog.Show("Iꂽvf",
                    $"vfJeS: {categeryName}\n" +
                    $"t@~: {familyName}\n" +
                    $"^Cv: {typeName}");

                return Result.Succeeded;
            }
            catch (Autodesk.Revit.Exceptions.OperationCanceledException)
            {
                // [U[LZꍇ
                return Result.Cancelled;
            }
            catch (Exception ex)
            {
                // ̑̃G[ꍇ

                message = $"G[܂: {ex.Message}";
                return Result.Failed;
            }
        }
    }
    public class WallSelectionFilter : ISelectionFilter
    {
        private readonly Document doc;
        //RXgN^
        public WallSelectionFilter(Document doc)
        {
            this.doc = doc;
        }
        //vf̑I邩ǂ̃\bh
		public bool AllowElement(Element elem)
		{
		    if (elem is Autodesk.Revit.DB.Wall)
		    {
		        return true;
		    }

		    return false;
		}
		//vf̖ʂGbWȂǃWIgւ̎QƂIł邩ǂ̃\bh
		public bool AllowReference(Reference reference, XYZ position)
		{
		    return false;
		}
	}
}
