#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;

#endregion

namespace RevitAddinWall2
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;

            //JeSAIꂽvf̕ϐ錾
            string categeryName = "";
            Element selectElement = null;

            try
            {
                while (true)
                {
                    // [U[ɕǃCX^XIĂ炤
                    Reference myRef = uidoc.Selection.PickObject(ObjectType.Element, "ǂIĂBLZɂESC܂");

                    // Iꂽvf擾
                    selectElement = doc.GetElement(myRef);

                    //elementsɑIvfǉĂ
                    elements.Insert(selectElement);

                    // JeS擾
                    categeryName = selectElement.Category.Name;

                    // vfǂł邱ƂmF
                    if (selectElement is Wall)
                    {
                        break;
                    }
                    else
                    {
                        // IꂽvfǂłȂꍇAēxI𑣂
                        TaskDialog.Show("IG[", categeryName+"I܂BǂIȂĂB");
                        throw new Exception();
                    }
                }
                // t@~A^CvAJeS擾
                Wall wall = selectElement as Wall;
                string familyName = wall.WallType.FamilyName;
                string typeName = wall.WallType.Name;

                // ʂ\
                TaskDialog.Show("Iꂽvf",
                    $"vfJeS: {categeryName}\n" +
                    $"t@~: {familyName}\n" +
                    $"^Cv: {typeName}");

                return Result.Succeeded;

            }
            catch (Autodesk.Revit.Exceptions.OperationCanceledException)
            {
                // [U[LZꍇ
                return Result.Cancelled;
            }
            catch (Exception ex)
            {
                // ̑̃G[ꍇ
                message = $"G[܂: {ex.Message}";
                return Result.Failed;
            }
        }
    }
}
