#region Namespaces
using System;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;
using System.IO;
using System.Xml.Linq;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Architecture;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using Microsoft.Win32;
using OfficeOpenXml;
using OfficeOpenXml.FormulaParsing.Excel.Functions.Logical;
using OfficeOpenXml.Style;
using static System.Runtime.InteropServices.JavaScript.JSType;

#endregion

namespace RevitAddinRooms
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;

            // \`̃f[^߂DataTable쐬  
            DataTable datatable = new DataTable("tblData");
            // 񖼁A^ݒ肷  
            datatable.Columns.Add("K", typeof(string));
            datatable.Columns.Add("K̒n㍂", typeof(double));
            datatable.Columns.Add("ԍ", typeof(int));
            datatable.Columns.Add("", typeof(string));
            datatable.Columns.Add("ʐ(m2)", typeof(double));
            datatable.Columns.Add("e(m3)", typeof(double));

            // tB^Ńf̒̑SĂ̕𒊏o  
            FilteredElementCollector col = new FilteredElementCollector(doc).OfCategory(BuiltInCategory.OST_Rooms);

            //Revit̗eόvZݒ肪ONɂȂĂ邩̃tO
            bool isVolumeCompEnable = false;

            // DataTableŕ𐮗  
            foreach (Room room in col)
            {
                var row = datatable.NewRow();
                string level = room.get_Parameter(BuiltInParameter.ROOM_LEVEL_ID).AsValueString();// K  
                double levelHeight = room.Level.get_Parameter(BuiltInParameter.LEVEL_ELEV).AsDouble();// K̒n㍂
                int roomNumber = int.Parse(room.get_Parameter(BuiltInParameter.ROOM_NUMBER).AsString());// ԍ  
                string roomName = room.get_Parameter(BuiltInParameter.ROOM_NAME).AsString();//   
                double roomArea = room.get_Parameter(BuiltInParameter.ROOM_AREA).AsDouble();// ʐ  
                roomArea = UnitUtils.ConvertFromInternalUnits(roomArea, UnitTypeId.SquareMeters);
                double roomVolume = room.get_Parameter(BuiltInParameter.ROOM_VOLUME).AsDouble();// e  
                roomVolume = UnitUtils.ConvertFromInternalUnits(roomVolume, UnitTypeId.CubicMeters);

                //S̗̕eόvZ0ƗeόvZOFFƔf
                if (roomVolume > 0) isVolumeCompEnable = true;

                row[0] = level;
                row[1] = levelHeight;
                row[2] = roomNumber;
                row[3] = roomName;
                row[4] = roomArea;
                row[5] = roomVolume;
                datatable.Rows.Add(row);
            }
            //eόvZ\`FbN
            if (!isVolumeCompEnable)
            {
                // eόvZOFF̏ꍇ͌xo  
                TaskDialog.Show("LZ", "eόvZOFFɂȂĂ܂B̓LZ܂BRevit̗eόvZݒmFĂB");
                return Result.Cancelled;
            }

            // \[g  
            DataView dv = datatable.DefaultView;
            dv.Sort = "K̒n㍂, ԍ";
            DataTable sortedtable = dv.ToTable();

            // uK̒n㍂vExcelɏo͂Ȃꍇɂ͍폜
            //sortedtable.Columns.Remove("K̒n㍂");

            // ɁAꗗExcelɕۑ邽߂̃_CAOJ  
            SaveFileDialog saveFileDialog = SaveExcel();
            string filename = saveFileDialog.FileName;

            // ۑt@Cɓ͂ĂExcelۑs  
            if (filename != "")
            {
                // [U[w肵Excelt@CŃt@CXg[擾  
                FileStream fs = (FileStream)saveFileDialog.OpenFile();
                // ExcelPackage쐬  
                using (ExcelPackage excel = new ExcelPackage(fs))
                {
                    // Excel̃[NV[gRoomsƂ̂̃V[g  
                    ExcelWorksheet worksheet = excel.Workbook.Worksheets.Add("Rooms");
                    // Excel̈ԍ̈ʒuA1DataTableCɗ  
                    worksheet.Cells["A1"].LoadFromDataTable(sortedtable, true);
                    // Excel̑SV[gɑ΂ď𐮂  
                    foreach (ExcelWorksheet sheet in excel.Workbook.Worksheets)
                    {
                        // 񕝂̓I[gtBbgBŌɎsق悢  
                        for (int i = 1; i < sheet.Dimension.End.Column; i++)
                        {
                            sheet.Column(i).AutoFit();
                            sheet.Column(i).Style.HorizontalAlignment = ExcelHorizontalAlignment.Left;
                        }
                        // ̗͉Eɂ  
                        for (int i = 5; i <= 6; i++)
                        {
                            sheet.Column(i).Style.HorizontalAlignment = ExcelHorizontalAlignment.Right;
                        }
                    }
                    // ExcelҏW̏I@Excelt@Cۑ  
                    excel.Save();

                    // 펞ɃbZ[Wo  
                    TaskDialog.Show("I", "Excelo͂͐IB̌Excelt@CJ܂B");
                    // mF̂߂ExcelNĕۑt@CJ  
                    Process process = new Process();
                    process.StartInfo.FileName = filename; // t@Ĉݎw  
                    process.StartInfo.UseShellExecute = true; // .NET8ł͂ꂪKv 
                    process.Start();
                }
            }
            else
            {
                // [U[Excelo͂̃_CAOŃt@C͂ĂȂALZꍇ͏LZ  
                TaskDialog.Show("LZ", "LZt@C܂BAhC͏I܂B");
                return Result.Cancelled;
            }
            return Result.Succeeded;
        }
        //Excelt@C̕ۑ̂߂̃_CAO
        public static SaveFileDialog SaveExcel()
        {
            // Excelt@Cɕۑ邽߂Ƀt@C[U[ɂ_CAO\  
            SaveFileDialog saveFileDialog = new SaveFileDialog();
            saveFileDialog.Filter = "ExcelFiles | *.xls;*.xlsx;*.xlsm";
            saveFileDialog.Title = "EXCELt@Cۑ";
            saveFileDialog.ShowDialog();
            // [U[t@CgqȂꍇɂxlsɂȂĂ܂BƂŊJƂɌxôł炩xlsxɕύXĂ  
            // filename̓[U[ꂸɃLZ{^ƋɂȂĂ܂B  
            string filename = saveFileDialog.FileName;
            // p󔒂܂܂ĂExcelAvNɃt@CȂG[oꍇ̂Ŕp󔒂A_[XRAɒu 
            filename = filename.Replace(" ", "_");
            if (filename.IndexOf("xlsx") < 0)
            {
                // SaveFileDialogIuWFNgFileNameύXĂ  
                saveFileDialog.FileName = filename.Split('.')[0] + ".xlsx";
            }
            return saveFileDialog;
        }
    }
}
