#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;

#endregion

namespace RevitAddinMoveWall
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;

            // ItB^[ݒ
            WallSelectionFilter filter = new WallSelectionFilter(doc);

            try
            {
                // tB^[tŃ[U[ɕǃCX^XIĂ炤
                Reference myRef = uidoc.Selection.PickObject(ObjectType.Element, filter, "ǂIĂBLZɂESC܂");

                // Iꂽvf擾
                Element selectElement = doc.GetElement(myRef);
                // t@~A^CvAJeS擾
                Wall wall = selectElement as Wall;

                // ړƋBX6400mmړ
                XYZ moveDistance = new XYZ(6400, 0, 0);
                double x = UnitUtils.ConvertToInternalUnits(moveDistance.X, UnitTypeId.Millimeters);
                double y = UnitUtils.ConvertToInternalUnits(moveDistance.Y, UnitTypeId.Millimeters);
                double z = UnitUtils.ConvertToInternalUnits(moveDistance.Z, UnitTypeId.Millimeters);
                XYZ translation = new XYZ(x, y, z);

                using (Transaction tx = new Transaction(doc, "Disallow Wall Joins"))
                {
                    tx.Start();
                    // ǂ̗[̘A
                    WallUtils.DisallowWallJoinAtEnd(wall, 0);
                    WallUtils.DisallowWallJoinAtEnd(wall, 1);
                    tx.Commit();
                }

                using (Transaction tx = new Transaction(doc, "Move Wall"))
                {
                    tx.Start();
                    // ǂړ
                    ElementTransformUtils.MoveElement(doc, wall.Id, translation);
                    tx.Commit();
                }
                //ēxǂ̘Asɂ͈ȉړɃgUNVŎs
                //WallUtils.AllowWallJoinAtEnd(wall, 0);
                //WallUtils.AllowWallJoinAtEnd(wall, 1);
            }
            catch (Autodesk.Revit.Exceptions.OperationCanceledException)
            {
                // [U[LZꍇ
                return Result.Cancelled;
            }
            catch (Exception ex)
            {
                // ̑̃G[ꍇ
                message = $"G[܂: {ex.Message}";
                return Result.Failed;
            }
            return Result.Succeeded;
        }
    }
    public class WallSelectionFilter : ISelectionFilter
    {
        private readonly Document doc;
        //RXgN^
        public WallSelectionFilter(Document doc)
        {
            this.doc = doc;
        }
        //vf̑I邩ǂ̃\bh
        public bool AllowElement(Element elem)
        {
            if (elem is Autodesk.Revit.DB.Wall)
            {
                return true;
            }
            return false;
        }
        //vf̖ʂGbWȂǃWIgւ̎QƂIł邩ǂ̃\bh
        public bool AllowReference(Reference reference, XYZ position)
        {
            return false;
        }
    }
}
