#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Structure;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;

#endregion

namespace RevitAddinInstallWindow
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;

            //*****************
            //^Cv
            string windowTypeName = "w1600h0800";
            //ǂIĂ炤
            Reference wallRef = uidoc.Selection.PickObject(ObjectType.Element, "ݒuǂIĂ");
            Wall wall = doc.GetElement(wallRef) as Wall;

            try
            {
                // ݊JĂ镽ʃr[̃x擾
                Level level = null;
                View activeView = uidoc.ActiveView;
                //ʃr[H
                if (activeView is ViewPlan viewPlan)
                {
                    // ʃr[̃x擾
                    level = doc.GetElement(viewPlan.GenLevel.Id) as Level;
                }
                else
                {
                    TaskDialog.Show("G[", "݂̃r[͕ʃr[ł͂܂B");
                    return Result.Failed;
                }
                //̐ݒuʒuvZ
                // ̔zuʒui: ǂ̒SW擾Azlevel.Elevationݒj
                LocationCurve wallCurve = wall.Location as LocationCurve;
                XYZ wallMidPoint = null;
                XYZ pos = null;
                if (wallCurve != null)
                {
                    wallMidPoint = (wallCurve.Curve.GetEndPoint(0) + wallCurve.Curve.GetEndPoint(1)) / 2;
                    //̓x̍ɐݒ
                    double z = level.Elevation;                  
                    pos = new XYZ(wallMidPoint.X, wallMidPoint.Y, z);
                }
                else
                {
                    TaskDialog.Show("G[", "ǂ̃J[u擾ł܂");
                }
                //vWFNgɓo^ĂLɑΉ^CviV{jĎ擾
                FamilySymbol windowType = new FilteredElementCollector(doc).OfClass(typeof(FamilySymbol))
                    .OfCategory(BuiltInCategory.OST_Windows).FirstOrDefault(q => q.Name == windowTypeName) as FamilySymbol;

                //^Cvp[^́u̍v擾Ĉʒu̕ϐposZWijɉZ
                double koshidaka = 0;
                if (double.TryParse(GetParameter(windowType, "̍"), out double v)) koshidaka = v;
                pos = pos.Add(new XYZ(0,0, koshidaka));

                //zu
                if (windowType != null && level != null && wall != null)
                {
                    using (Transaction tx = new Transaction(doc))
                    {
                        tx.Start("Install Window");
                        //^CvANeBuȂANeBuɂ
                        if (!windowType.IsActive) windowType.Activate();
                        //zu
                        FamilyInstance window = doc.Create.NewFamilyInstance(pos, windowType, wall, level, StructuralType.NonStructural);
                        tx.Commit();
                    }
                }
                else
                {
                    TaskDialog.Show("G[", "^CvAxAǂ̂ꂩnullł");
                }
            }
            catch (Exception ex)
            {
                // Oꍇ̃G[bZ[W
                TaskDialog.Show("G[", $"̔zuɎs܂BG[bZ[WF{ex.Message}");
                return Result.Failed;
            }
            return Result.Succeeded;
        }
        //P̗vf̎wp[^擾֐
        public string GetParameter(Element e, string pName)
        {
            //p[^̓ꕨ
            IList<Parameter> parameters = new List<Parameter>();
            //Sp[^擾iRevit̃vpeBEBhEɕ\́j
            parameters = e.GetOrderedParameters();
            foreach (Parameter param in parameters)
            {
                //Ăp[^ƈv邩
                string name = param.Definition.Name;
                if (name.Equals(pName))
                {
                    //v炻Ԃ
                    return ParameterToString(param);
                }
            }
            return null;
        }
        //p[^stringɕϊ֐
        public static string ParameterToString(Parameter param)
        {
            string val = null;
            if (param == null)
            {
                return val;
            }
            switch (param.StorageType)
            {
                case StorageType.Double:
                    double dVal = param.AsDouble();
                    val = dVal.ToString();
                    break;
                case StorageType.Integer:
                    int iVal = param.AsInteger();
                    val = iVal.ToString();
                    break;
                case StorageType.String:
                    string sVal = param.AsString();
                    val = sVal;
                    break;
                case StorageType.ElementId:
                    ElementId idVal = param.AsElementId();
                    val = idVal.ToString();
                    break;
                case StorageType.None:
                    break;
                default:
                    break;
            }
            return val;
        }
    }
}
