﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace RevitAddinInstallLightingFixture
{
    /// <summary>
    /// Window1.xaml の相互作用ロジック
    /// </summary>
    public partial class Window1 : Window
    {
        private int xNumber;
        private int yNumber;
        private int height;
        public Window1()
        {
            InitializeComponent();
            this.Title = "照明器具配置の台数設定";
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            if (int.TryParse(xCount.Text, out int valueX))
            {
                xNumber = valueX;
            }
            else
            {
                MessageBox.Show("横方向台数に数値を入力してください。");
                return;
            }
            if (int.TryParse(yCount.Text, out int valueY))
            {
                yNumber = valueY;
            }
            else
            {
                MessageBox.Show("縦方向台数に数値を入力してください。");
                return;
            }
            if (int.TryParse(heightFromFL.Text, out int valueHeight))
            {
                height = valueHeight;
            }
            else
            {
                MessageBox.Show("設置高さに数値を入力してください。");
                return;
            }
            this.DialogResult = true; // OKが押されたことを示す
            this.Close();
        }

        private void Button_Click_1(object sender, RoutedEventArgs e)
        {
            this.Close();
        }
        public int GetXNumber()
        {
            return xNumber;
        }
        public int GetYNumber()
        {
            return yNumber;
        }
        public int GetHeight()
        {
            return height;
        }

        private void Window1_Loaded(object sender, RoutedEventArgs e)
        {
            xCount.Focus();
            
        }
    }
}
