#region Namespaces
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Structure;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using System;
using System.Collections.Generic;
using System.Diagnostics;

#endregion

namespace RevitAddinInstallHVAC
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;

            //*****************
            //󒲋@t@~ƃ^Cv
            string ACFamilyName = "07062_ACP-CID_@_V䖄_Ng`";
            string ACTypeName = "9.0kW";

            try
            {
                // ̋󒲋@䐔
                int xNumber = 0;
                // c̋󒲋@䐔
                int yNumber = 0;
                //ݒu
                double height = 0;
                // Window\ă[U[ɉƏc̑䐔͂Ă炤
                Window1 window1 = new Window1();
                bool? result = window1.ShowDialog();
                // OK{^ꂽǂmF
                if (result == true)
                {
                    // okButtonꂽc̑䐔A擾
                    xNumber = window1.GetXNumber();
                    yNumber = window1.GetYNumber();
                    height = window1.GetHeight();
                    height = UnitUtils.ConvertToInternalUnits(height, UnitTypeId.Millimeters);
                }
                else
                {
                    // LZ{^ꂽꍇ̏
                    return Result.Cancelled;
                }

                // ݊JĂ镽ʃr[̃x擾
                Level level = null;
                View activeView = uidoc.ActiveView;
                //ʃr[H
                if (activeView is ViewPlan viewPlan)
                {
                    // ʃr[̃x擾
                    level = doc.GetElement(viewPlan.GenLevel.Id) as Level;
                }
                else
                {
                    TaskDialog.Show("G[", "݂̃r[͕ʃr[ł͂܂B");
                    return Result.Failed;
                }
                // Xy[XpItB^[ݒ
                SpaceSelectionFilter filter = new SpaceSelectionFilter(doc);
                Reference myRef = uidoc.Selection.PickObject(ObjectType.Element, filter, "Xy[XIĂBLZɂESC܂");
                // Iꂽvf擾
                Element selectElement = doc.GetElement(myRef);
                //selectElementXy[XƂĔF
                Autodesk.Revit.DB.Mechanical.Space space = selectElement as Autodesk.Revit.DB.Mechanical.Space;
                //Xy[X̃oEfBO{bNX擾
                (XYZ pMin, XYZ pMax) = GetSpaceBoundary(space);
                //Xy[X̕Ɖs擾iPʂ̂܂܁j
                double width = pMax.X - pMin.X;
                double depth = pMax.Y - pMin.Y;
                //󒲋@̊ԊuvZ
                //̊Ԋu
                double dx = width / xNumber;
                //c̊Ԋu
                double dy = depth / yNumber;

                //vWFNgɓo^ĂLɑΉ󒲋@^CviV{jĎ擾
                FamilySymbol acType = new FilteredElementCollector(doc)
                    .OfClass(typeof(FamilySymbol))
                    .OfCategory(BuiltInCategory.OST_MechanicalEquipment)
                    .Cast<FamilySymbol>()
                    .FirstOrDefault(x => (x.Family.Name == ACFamilyName)
                    && ((x.Name == ACTypeName)));

                //󒲋@zu
                if (acType != null && level != null && space != null)
                {
                    using (Transaction tx = new Transaction(doc))
                    {
                        tx.Start("Install HVAC");
                        //󒲋@^CvANeBuȂANeBuɂ
                        if (!acType.IsActive) acType.Activate();
                        //zu
                        for (int i = 0; i < xNumber; i++)
                        {
                            for (int j = 0; j < yNumber; j++)
                            {
                                //zu|CgvZ
                                XYZ pos = new XYZ(pMin.X + dx / 2 + i * dx, pMin.Y + dy / 2 + j * dy, height);
                                //󒲋@zu
                                FamilyInstance lightingFixture = doc.Create.NewFamilyInstance(pos, acType, level, StructuralType.NonStructural);
                            }
                        }
                        tx.Commit();
                    }
                }
                else
                {
                    TaskDialog.Show("G[", "󒲋@^CvAxAXy[X̂ꂩnullł");
                }
            }
            catch (Exception ex)
            {
                // Oꍇ̃G[bZ[W
                TaskDialog.Show("G[", $"󒲋@̔zuɎs܂BG[bZ[WF{ex.Message}");
                return Result.Failed;
            }
            return Result.Succeeded;
        }
        public (XYZ pMin, XYZ pMax) GetSpaceBoundary(Autodesk.Revit.DB.Mechanical.Space space)
        {
            //spacẽoEfBO{bNX擾
            BoundingBoxXYZ bb = space.get_BoundingBox(null);
            //space̍ŏ_ƍő_擾
            XYZ pMin = bb.Min;
            XYZ pMax = bb.Max;
            return (pMin, pMax);
        }
    }
    //Xy[XI\ɂtB^[
    public class SpaceSelectionFilter : ISelectionFilter
    {
        private readonly Document doc;
        //RXgN^
        public SpaceSelectionFilter(Document doc)
        {
            this.doc = doc;
        }
        //vf̑I邩ǂ̃\bh
        public bool AllowElement(Element elem)
        {
            if (elem is Autodesk.Revit.DB.SpatialElement)
            {
                return true;
            }
            return false;
        }
        //vf̖ʂGbWȂǃWIgւ̎QƂIł邩ǂ̃\bh
        public bool AllowReference(Reference reference, XYZ position)
        {
            return false;
        }
    }
}
