#region Namespaces
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Architecture;
using Autodesk.Revit.DB.Structure;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Windows;
using System.Windows.Media.Media3D;

#endregion

namespace RevitAddinInstallFurniture
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Autodesk.Revit.ApplicationServices.Application app = uiapp.Application;
            Document doc = uidoc.Document;

            //*****************
            //Ƌt@~ƃ^Cv
            string ACFamilyName = "RN_fXN_[NBX^+__Œ莮_D1200_{";
            string ACTypeName = "W3000_V_r";

            try
            {
                // ̉Ƌ䐔
                int xNumber = 9;//2䂲Ƃ1䕪Room̂Ŏzu6ƂȂ
                // c̉Ƌ䐔
                int yNumber = 3;
                //̔zuԊu
                double xInterval = 3000;//mm
                xInterval = UnitUtils.ConvertToInternalUnits(xInterval, UnitTypeId.Millimeters);
                //c̔zuԊu
                double yInterval = 4000;//mm
                yInterval = UnitUtils.ConvertToInternalUnits(yInterval, UnitTypeId.Millimeters);

                // ݊JĂ镽ʃr[̃x擾
                Level level = null;
                View activeView = uidoc.ActiveView;
                //ʃr[H
                if (activeView is ViewPlan viewPlan)
                {
                    // ʃr[̃x擾
                    level = doc.GetElement(viewPlan.GenLevel.Id) as Level;
                }
                else
                {
                    TaskDialog.Show("G[", "݂̃r[͕ʃr[ł͂܂B");
                    return Result.Failed;
                }
                // RoompItB^[ݒ
                RoomSelectionFilter filter = new RoomSelectionFilter(doc);
                Reference myRef = uidoc.Selection.PickObject(ObjectType.Element, filter, "RoomIĂBLZɂESC܂");
                // Iꂽvf擾
                Element selectElement = doc.GetElement(myRef);
                //selectElementRoomƂĔF
                Autodesk.Revit.DB.Architecture.Room room = selectElement as Autodesk.Revit.DB.Architecture.Room;
                //Room̃oEfBO{bNX擾iƋzůJn_肷邽߁j
                (XYZ pMin, XYZ pMax) = GetRoomBoundary(room);
                
                //vWFNgɓo^ĂLɑΉƋ^CviV{jĎ擾
                FamilySymbol furnitureType = new FilteredElementCollector(doc)
                    .OfClass(typeof(FamilySymbol))
                    .OfCategory(BuiltInCategory.OST_Furniture)
                    .Cast<FamilySymbol>()
                    .FirstOrDefault(x => (x.Family.Name == ACFamilyName)
                    && ((x.Name == ACTypeName)));

                //Ƌzu
                if (furnitureType != null && level != null && room != null)
                {
                    using (Transaction tx = new Transaction(doc))
                    {
                        tx.Start("Install FURNITURE");
                        //Ƌ^CvANeBuȂANeBuɂ
                        if (!furnitureType.IsActive) furnitureType.Activate();
                        //zu
                        for (int i = 0; i < xNumber; i++)
                        {
                            for (int j = 0; j < yNumber; j++)
                            {
                                //zu|CgvZ
                                XYZ pos = new XYZ(pMin.X + xInterval + i * xInterval, pMin.Y + yInterval + j * yInterval, 0);
                                //ƋzuiR̔{̂ƂRoomɂ̂ŉƋzuȂj
                                if((i % 3) != 0)
                                {
                                    FamilyInstance lightingFixture = doc.Create.NewFamilyInstance(pos, furnitureType, level, StructuralType.NonStructural);
                                }
                            }
                        }
                        tx.Commit();
                    }
                }
                else
                {
                    TaskDialog.Show("G[", "Ƌ^CvAxARoom̂ꂩnullł");
                }
            }
            catch (Exception ex)
            {
                // Oꍇ̃G[bZ[W
                TaskDialog.Show("G[", $"Ƌ̔zuɎs܂BG[bZ[WF{ex.Message}");
                return Result.Failed;
            }
            return Result.Succeeded;
        }
        public (XYZ pMin, XYZ pMax) GetRoomBoundary(Autodesk.Revit.DB.Architecture.Room room)
        {
            //spacẽoEfBO{bNX擾
            BoundingBoxXYZ bb = room.get_BoundingBox(null);
            //space̍ŏ_ƍő_擾
            XYZ pMin = bb.Min;
            XYZ pMax = bb.Max;
            return (pMin, pMax);
        }
    }
    //RoomI\ɂtB^[
    public class RoomSelectionFilter : ISelectionFilter
    {
        private readonly Document doc;
        //RXgN^
        public RoomSelectionFilter(Document doc)
        {
            this.doc = doc;
        }
        //vf̑I邩ǂ̃\bh
        public bool AllowElement(Element elem)
        {
            if (elem is Autodesk.Revit.DB.Architecture.Room)
            {
                return true;
            }
            return false;
        }
        //vf̖ʂGbWȂǃWIgւ̎QƂIł邩ǂ̃\bh
        public bool AllowReference(Reference reference, XYZ position)
        {
            return false;
        }
    }
}
