#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Structure;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;

#endregion

namespace RevitAddinInstallDoor
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;

            //*****************
            //hA^Cv
            string doorTypeName = "w900h2000";
            //ǂIĂ炤
            Reference wallRef = uidoc.Selection.PickObject(ObjectType.Element, "hAݒuǂIĂ");
            Wall wall = doc.GetElement(wallRef) as Wall;

            try
            {
                // ݊JĂ镽ʃr[̃x擾
                Level level = null;
                View activeView = uidoc.ActiveView;
                //ʃr[H
                if (activeView is ViewPlan viewPlan)
                {
                    // ʃr[̃x擾
                    level = doc.GetElement(viewPlan.GenLevel.Id) as Level;
                }
                else
                {
                    TaskDialog.Show("G[", "݂̃r[͕ʃr[ł͂܂B");
                    return Result.Failed;
                }
                //hA̐ݒuʒuvZ
                // hA̔zuʒui: ǂ̒SW擾Azlevel.Elevationݒj
                LocationCurve wallCurve = wall.Location as LocationCurve;
                XYZ wallMidPoint = null;
                XYZ pos = null;
                if (wallCurve != null)
                {
                    wallMidPoint = (wallCurve.Curve.GetEndPoint(0) + wallCurve.Curve.GetEndPoint(1)) / 2;
                    //̓x̍ɐݒ
                    double z = level.Elevation;
                    pos = new XYZ(wallMidPoint.X, wallMidPoint.Y, z);
                }
                else
                {
                    TaskDialog.Show("G[", "ǂ̃J[u擾ł܂");
                }
                //vWFNgɓo^ĂLɑΉ^CviV{jĎ擾
                FamilySymbol doorType = new FilteredElementCollector(doc).OfClass(typeof(FamilySymbol))
                    .OfCategory(BuiltInCategory.OST_Doors).FirstOrDefault(q => q.Name == doorTypeName) as FamilySymbol;
                //hAzu
                if (doorType != null && level != null && wall != null)
                {
                    using (Transaction tx = new Transaction(doc))
                    {
                        tx.Start("Install Door");
                        //hA^CvANeBuȂANeBuɂ
                        if (!doorType.IsActive) doorType.Activate();
                        //zu
                        FamilyInstance door = doc.Create.NewFamilyInstance(pos, doorType, wall, level, StructuralType.NonStructural);
                        tx.Commit();
                    }
                }
                else
                {
                    TaskDialog.Show("G[", "hA^CvAxAǂ̂ꂩnullł");
                }
            }
            catch (Exception ex)
            {
                // Oꍇ̃G[bZ[W
                TaskDialog.Show("G[", $"hA̔zuɎs܂BG[bZ[WF{ex.Message}");
                return Result.Failed;
            }
            return Result.Succeeded;
        }
    }
}
