#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Runtime.Intrinsics.X86;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;

#endregion

namespace RevitAddinDoors
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;

            //t@~^Cvʂ̔̐fBNVi
            Dictionary<string, int> doorsDict = new Dictionary<string, int>();

            //tB^[hGgRN^[Ńf̒̑SĂ̕ǂ𒊏o
            IList<Element> doors = new FilteredElementCollector(doc).OfClass(typeof(FamilyInstance))
                .OfCategory(BuiltInCategory.OST_Doors).ToElements();

            string info = "hA̐: " + doors.Count.ToString()+"\n";
            foreach (Element item in doors)
            {
                //t@~A^Cv擾
                FamilyInstance door = item as FamilyInstance;
                string doorTypeName = door.Symbol.Name;
                string doorFamilyName = door.Symbol.Family.Name;

                // fBNVĩL[̂߂ɕ쐬B"@"̓t@~ƃ^Cv𕪗邽ߋ؎q
                string doorFamilyAndType = doorFamilyName + "@" + doorTypeName;

                // fBNVi̒ɃL[doorFamilyAndType݂邩mF
                if (doorsDict.TryGetValue(doorFamilyAndType, out int count))
                {
                    // ݂ꍇ1Z
                    doorsDict[doorFamilyAndType] = count + 1;
                }
                else
                {
                    doorsDict.Add(doorFamilyAndType, 1);
                }
            }
            // Dictionary̒g\            
            foreach (KeyValuePair<string, int> keyValue in doorsDict)
            {
                //L[
                string key = keyValue.Key;
                //o[
                int v = keyValue.Value;

                //keyt@~ƃ^Cvɕ
                string[] k = key.Split("@");

                //infoɏǉ
                info += $"{k[0]} \t {k[1]} \t {v.ToString()}\n";
            }
            // ʂ\
            TaskDialog.Show("̈ꗗ", $"{info}");
            return Result.Succeeded;
        }
    }
}
