#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;

#endregion

namespace RevitAddinCreateWall
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;

            /*
            //̕ǂ肽ꍇɂ͎̃f[^pӂ܂B
            //4_ݒ肷
            XYZ p1 = new XYZ(Uni(20000), Uni(800), 0);
            XYZ p2 = new XYZ(Uni(25000), Uni(800), 0);
            XYZ p3 = new XYZ(Uni(25000), Uni(5800), 0);
            XYZ p4 = new XYZ(Uni(20000), Uni(5800), 0);
            //e_Ԑ胊XgɊi[
            List<Curve> wallLines = new List<Curve>();
            wallLines.Add(Line.CreateBound(p1, p2));
            wallLines.Add(Line.CreateBound(p2, p3));
            wallLines.Add(Line.CreateBound(p3, p4));
            wallLines.Add(Line.CreateBound(p4, p1));
            */

            //*****************
            //ǃ^Cv
            string newWallTypeName = "(L#)EB1/EB1";
            // ǂ̈ʒuiLinej
            double startX = 19200; startX= UnitUtils.ConvertToInternalUnits(startX, UnitTypeId.Millimeters);
            double startY = 400; startY = UnitUtils.ConvertToInternalUnits(startY, UnitTypeId.Millimeters);
            double startZ = 0; startZ = UnitUtils.ConvertToInternalUnits(startZ, UnitTypeId.Millimeters);
            XYZ start = new XYZ(startX, startY, startZ);
            double endX = 19200; endX = UnitUtils.ConvertToInternalUnits(endX, UnitTypeId.Millimeters);
            double endY = 13200- 400; endY = UnitUtils.ConvertToInternalUnits(endY, UnitTypeId.Millimeters);
            double endZ = 0; endZ = UnitUtils.ConvertToInternalUnits(endZ, UnitTypeId.Millimeters);
            XYZ end = new XYZ(endX, endY, endZ);
            //ǂ̒Line
            Line line = Line.CreateBound(start, end);

            //ǂ̍
            double height = 2858;
            height = UnitUtils.ConvertToInternalUnits(height, UnitTypeId.Millimeters);

            //̃ItZbg
            double offset = 0;

            //݊JĂ镽ʃr[̃x擾
            Level level = null;
            View activeView = uidoc.ActiveView;
            //ʃr[H
            if (activeView is ViewPlan viewPlan)
            {
                // ʃr[̃x擾
                level = doc.GetElement(viewPlan.GenLevel.Id) as Level;
            }
            else
            {
                TaskDialog.Show("G[", "݂̃r[͕ʃr[ł͂܂B");
                return Result.Failed;
            }

            //ǃ^Cv
            WallType wallType = null;
            try
            {
                wallType = new FilteredElementCollector(doc).OfClass(typeof(WallType)).Where(typ => typ.Name == newWallTypeName).First() as WallType;
                //ǂ쐬
                if (wallType != null)
                {
                    using (Transaction tx = new Transaction(doc))
                    {
                        tx.Start("Create Wall");
                        // P̕Ǎ쐬
                        Wall wall = Wall.Create(doc, line, wallType.Id, level.Id, height, offset, false, false);
                        // ǂ̌
                        WallUtils.AllowWallJoinAtEnd(wall, 0);
                        WallUtils.AllowWallJoinAtEnd(wall, 1);

                        /*
                        //̕ǂCɍɂ͈ȉg
                        foreach (var wallLine in wallLines)
                        {
                            Wall wall = Wall.Create(doc, wallLine, wallType.Id, level.Id, height, offset, false, false);
                            // ǂ̌
                            WallUtils.AllowWallJoinAtEnd(wall, 0);
                            WallUtils.AllowWallJoinAtEnd(wall, 1);
                        }
                        */
                        tx.Commit();
                    }
                }
            }
            catch (Exception ex)
            {
                // Oꍇ̃G[bZ[W
                TaskDialog.Show("G[", $"w肳ꂽǃ^Cv '{newWallTypeName}' ܂BG[bZ[WF{ex.Message}");
                return Result.Failed;
            }
            
            return Result.Succeeded;
        }
        //~[gPʂPʂɕϊ
        private double Uni(double x)
        {
            return UnitUtils.ConvertToInternalUnits(x, UnitTypeId.Millimeters);
        }
    }
}
