#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;

#endregion

namespace RevitAddinCreateSheets
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;
            View activeView = uidoc.ActiveView;
            //V[gi}ʃXgj
            string[,] zumenList = new string[,]
                    {
                    { "A101","FloorPlan","1Kʐ}","x 1"},
                    { "A102","FloorPlan","2Kʐ}","x 2"}
                    };
            //s
            int rowsOfZumen = zumenList.GetLength(0);
            //
            int columnsOfZumen = zumenList.GetLength(1);

            //}ʘgt@~ƃ^Cvw
            string zumenwakuFamilyName = "}ʘg A1";
            string zumenwakuTypeName = "}ʘg A1";
            // }ʘg̃t@~^Cv擾
            FamilySymbol titleBlockType = new FilteredElementCollector(doc)
                .OfClass(typeof(FamilySymbol))
                .OfCategory(BuiltInCategory.OST_TitleBlocks)
                .Cast<FamilySymbol>()
                .FirstOrDefault(x => (x.Family.Name == zumenwakuFamilyName)
                && ((x.Name == zumenwakuTypeName)));

            if (titleBlockType == null)
            {
                message = "}ʘgt@~^Cv܂B";
                return Result.Failed;
            }
            //}ʘgBoundingBox擾
            BoundingBoxXYZ boundingBox = titleBlockType.get_BoundingBox(doc.ActiveView);
            //}ʘg̒SW擾(}ʘg̒SɃV[gzu邽)
            XYZ center = (boundingBox.Max + boundingBox.Min) / 2;

            using (Transaction tx = new Transaction(doc))
            {
                tx.Start("Transaction Create Sheets");
                //S̃V[g
                for (int i = 0; i < rowsOfZumen; i++)
                {
                    //V[gԍ
                    string sheetNumber = zumenList[i, 0];
                    //r[̃t@~^Cv
                    string viewFamilyTypeName = zumenList[i, 1];
                    //V[g
                    string sheetName = zumenList[i, 2];
                    //r[
                    string viewName = zumenList[i, 3];


                    //VV[g쐬
                    ViewSheet sheet = ViewSheet.Create(doc, titleBlockType.Id);
                    SetParameter(sheet, "V[gԍ", sheetNumber);
                    sheet.Name = sheetName; ;//V[g
                    //V[gɔzu镽ʃr[擾
                    View view = new FilteredElementCollector(doc)
                        .OfClass(typeof(View))
                        .Cast<View>()
                        .FirstOrDefault(v => (v.Name == viewName) && (v.ViewType.ToString() == viewFamilyTypeName));
                    //V[g̒ViewportAɕʃr[ǉ
                    if (view != null)
                    {
                        Viewport.Create(doc, sheet.Id, view.Id, center);
                    }
                }
                tx.Commit();
            }

            return Result.Succeeded;
        }
        public bool SetParameter(Element elem, string paramName, object val)
        {
            foreach (Parameter param in elem.GetOrderedParameters())
            {
                string name = param.Definition.Name;
                if (name.Equals(paramName))
                {
                    switch (val)
                    {
                        case string s:
                            param.Set(s);
                            break;
                        case int i:
                            param.Set(i);
                            break;
                        case double d:
                            param.Set(d);
                            break;
                        default:
                            return false;
                    }
                    return true;
                }
            }
            return false;
        }
    }
}
