#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;

#endregion

namespace RevitAddinCreateRoof
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;

            //*****************
            /* {AhCsOɉ̗֊s̃x[XɂȂA̕ǂKvł
             * Kx̖͈̂ȉ̕ɂKv܂BႤꍇɂ̓fƎ̖̂vύXKv
             * AhC̎ǵA܂ǂIŁǍɃAhCs菇łB
             * ^Cv͍ŏɌ̂gp悤ɂȂĂ܂B
             */
            // K̖
            string rfLevelName = "Roof";
            bool isSlope = true; // true:zAfalse:zȂ
            double slopeAngle = 0.5; // z̊pxi1/1=45xA1/2=26.57xA1/3=18.43xA1/4=14.04xA1/5=11.31xj

            // RFx
            FilteredElementCollector collector = new FilteredElementCollector(doc).OfClass(typeof(Level));
            var roofLevel = from element in collector where element.Name == rfLevelName select element;
            Level level = roofLevel.Cast<Level>().ElementAt<Level>(0);

            //RFxiʂ̕@j
            //Level level = new FilteredElementCollector(doc).OfClass(typeof(Level)).FirstOrDefault(q => q.Name == rfLevelName) as Level;

            if (level == null)
            {
                TaskDialog.Show("G[", $"K̖{rfLevelName}܂BmFĂB");
                return Result.Failed;
            }

            // ^Cv͍ŏɌ̂gp
            RoofType roofType = new FilteredElementCollector(doc).OfClass(typeof(RoofType)).FirstOrDefault() as RoofType;

            //^Cvw肷ꍇɂ́Aȉ̃RgAEgOĎgpB
            //AfɎw肵̂̉^Cv݂Kv܂B
            //̑3s̓RgAEgB
            //^Cv̎w
            //string roofTypeName = "RN[g-200mm";
            //^Cv
            //RoofType roofType = new FilteredElementCollector(doc).OfClass(typeof(RoofType)).Where(typ => typ.Name == roofTypeName).First() as RoofType;

            if (roofType == null)
            {
                TaskDialog.Show("G[", "̃^Cv܂BmFĂB");
                return Result.Failed;
            }

            // [U[I񂾕ǂɂĉ̗֊sCCurveArrayp
            CurveArray footprint = app.Create.NewCurveArray();

            // Iꂽvf擾
            ICollection<ElementId> selectedIds = uidoc.Selection.GetElementIds();
            if (selectedIds.Count != 0)
            {
                foreach (ElementId id in selectedIds)
                {
                    // IꂽvfǂfmF
                    Element element = doc.GetElement(id);
                    Wall wall = element as Wall;
                    if (wall != null)
                    {
                        // ǂłꍇɂ͂̈ʒuiLocationCurvej擾
                        LocationCurve wallCurve = wall.Location as LocationCurve;
                        // ̋Ȑ̗֊sɒǉ
                        if (wallCurve != null) footprint.Append(wallCurve.Curve);
                        continue;
                    }
                    // Iꂽvffłꍇ
                    ModelCurve modelCurve = element as ModelCurve;
                    if (modelCurve != null)
                    {
                        // ̋Ȑ̗֊sɒǉ
                        footprint.Append(modelCurve.GeometryCurve);
                    }
                }
            }
            else
            {
                TaskDialog.Show("G[", "ǂȂǉ̗֊sw肷̂IĂ܂BȐ[vAǃ[vA܂͕ǂƋȐ̑gݍ킹[vIKv܂B");
                return Result.Failed;
            }
            // ̗֊siNewFootPrintRoof\bh̎s̃fJ[uój
            ModelCurveArray footPrintToModelCurveMapping = new ModelCurveArray();
            try
            {
                //쐬
                using (Transaction tx = new Transaction(doc))
                {
                    tx.Start("Create Roof");
                    // zu
                    FootPrintRoof footprintRoof = doc.Create.NewFootPrintRoof(footprint, level, roofType, out footPrintToModelCurveMapping);
                    if (footprintRoof == null)
                    {
                        TaskDialog.Show("G[", "̍쐬̂ƂŎs܂B");
                        return Result.Failed;
                    }
                    // zݒ肷
                   
                    if (isSlope)
                    {
                        // ̗֊sfJ[uZbgĂ邩mF
                        if (footPrintToModelCurveMapping.Size != 0)
                        {
                            // ȂΉ̗֊sC^[^Ŏ擾
                            ModelCurveArrayIterator iterator = footPrintToModelCurveMapping.ForwardIterator();
                            iterator.Reset();
                            while (iterator.MoveNext())
                            {
                                // ̊e֊sijɌzݒ肷
                                ModelCurve modelCurve = iterator.Current as ModelCurve;
                                // zAȂݒ
                                footprintRoof.set_DefinesSlope(modelCurve, isSlope);
                                // z̊pxݒ
                                footprintRoof.set_SlopeAngle(modelCurve, slopeAngle);
                            }
                        }
                        else
                        {
                            TaskDialog.Show("G[", "̗֊sfJ[u擾łȂߌzݒł܂B");
                            return Result.Failed;
                        }
                    }
                    
                    tx.Commit();
                    return Result.Succeeded;
                }
            }
            catch (Exception ex)
            {
                // Oꍇ̃G[bZ[W
                TaskDialog.Show("G[", $"쐬ł܂BG[bZ[WF{ex.Message}");
                return Result.Failed;
            }
            return Result.Succeeded;
        }
    }
}
