#region Namespaces
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Windows.Controls;

#endregion

namespace RevitAddinCreateLevels
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;
            // xƃx̍̃f[^pӂ
            Dictionary<string, double> levelData = new Dictionary<string, double>();
            levelData.Add("x 3", UnitUtils.ConvertToInternalUnits(8.0, UnitTypeId.Meters));
            levelData.Add("x 4", UnitUtils.ConvertToInternalUnits(12.0, UnitTypeId.Meters));
            levelData.Add("x 5", UnitUtils.ConvertToInternalUnits(16.0, UnitTypeId.Meters));

            //tA[vViewFamilyType擾
            ViewFamilyType floorPlanType = new FilteredElementCollector(doc)
                .OfClass(typeof(ViewFamilyType))
                .Cast<ViewFamilyType>()
                .FirstOrDefault(x => x.ViewFamily == ViewFamily.FloorPlan);
            //V䕚ViewFamilyType擾
            ViewFamilyType ceilingPlanType = new FilteredElementCollector(doc)
                .OfClass(typeof(ViewFamilyType))
                .Cast<ViewFamilyType>()
                .FirstOrDefault(x => x.ViewFamily == ViewFamily.CeilingPlan);

            using (Transaction tx = new Transaction(doc))
            {
                tx.Start("Transaction Create Levels");
                // SẴx쐬
                foreach (KeyValuePair<string,double> levelElevation in levelData)
                {
                    // x쐬
                    Level level = Level.Create(doc, levelElevation.Value);
                    // xݒ肷
                    if(level != null)
                    {
                        level.Name = levelElevation.Key;
                    }
                    // ʃr[쐬
                    //ʃr[v쐬
                    if(floorPlanType != null && level != null)
                    {
                        ViewPlan floorViewPlan = ViewPlan.Create(doc, floorPlanType.Id, level.Id);
                        //r[̖Oݒ
                        floorViewPlan.Name = levelElevation.Key;
                        //r[̃XP[ݒ
                        floorViewPlan.Scale = 100;
                        // r[ev[gKp
                        /*
                        string floorViewTemplateName = "ABCDEFG";
                        View floorViewTemplate = new FilteredElementCollector(doc)
                            .OfClass(typeof(View))
                            .Cast<View>()
                            .FirstOrDefault(v => v.Name.Equals(floorViewTemplateName) && v.IsTemplate);
                        if(floorViewTemplate != null)
                        {
                            floorViewPlan.ViewTemplateId = floorViewTemplate.Id;
                        }
                        */
                    }
                    //V䕚r[v쐬
                    if (ceilingPlanType != null && level != null)
                    {
                        ViewPlan ceilingViewPlan = ViewPlan.Create(doc, ceilingPlanType.Id, level.Id);
                        //r[̖Oݒ
                        ceilingViewPlan.Name = levelElevation.Key;
                        //r[̃XP[ݒ
                        ceilingViewPlan.Scale = 100;
                        // r[ev[gKp
                        /*
                        string ceilingViewTemplateName = "ABCDEFG";
                        View ceilingViewTemplate = new FilteredElementCollector(doc)
                            .OfClass(typeof(View))
                            .Cast<View>()
                            .FirstOrDefault(v => v.Name.Equals(ceilingViewTemplateName) && v.IsTemplate);
                        if(ceilingViewTemplate != null)
                        {
                            ceilingViewPlan.ViewTemplateId = ceilingViewTemplate.Id;
                        }
                        */
                    }
                }
                tx.Commit();
            }
            return Result.Succeeded;
        }
    }
}
