#region Namespaces
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Windows.Controls;
using System.Windows.Shapes;

#endregion

namespace RevitAddinCreateGrids
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;
            View activeView = uidoc.ActiveView;

            //ʐc̏pӂ
            //Xʐc̊Jn_ƏI_YW
            double y1 = -3600;
            double y2 = 25200;
            //Xʐc̍WlƖ
            double[] x = { 0, 7200, 14400, 21600, 28800, 36000 };
            string[] symbolX = { "1", "2", "3", "4", "5", "6"};
            //Yʐc̊Jn_ƏI_XW
            double x1 = -3600;
            double x2 = 39600;
            //Yʐc̍WlƖ
            double[] y = { 0, 7200, 14400, 21600 };
            string[] symbolY = { "A", "B", "C", "D" };

            //쐬Obhi[郊Xg
            List<Autodesk.Revit.DB.Grid> gridX = new List<Autodesk.Revit.DB.Grid>();
            List<Autodesk.Revit.DB.Grid> gridY = new List<Autodesk.Revit.DB.Grid>();

            using (Transaction tx = new Transaction(doc))
            {
                tx.Start("Transaction Create Grids");
                for (int i = 0; i < x.Length; i++)
                {
                    //X@ʐcJn_ƏI_XYZW쐬
                    XYZ start = new XYZ(CVmmToInt(x[i]), CVmmToInt(y1), 0);
                    XYZ end = new XYZ(CVmmToInt(x[i]), CVmmToInt(y2), 0);
                    //쐬
                    Autodesk.Revit.DB.Line line = Autodesk.Revit.DB.Line.CreateBound(start, end);
                    //Obhiʐcj쐬
                    Autodesk.Revit.DB.Grid grid = Autodesk.Revit.DB.Grid.Create(doc, line);
                    //Obhiʐcjɖ̂ݒ
                    grid.Name = symbolX[i];
                    //Xgɒǉ
                    gridX.Add(grid);
                }

                for (int i = 0; i < y.Length; i++)
                {
                    //Y@ʐcJn_ƏI_XYZW쐬
                    XYZ start = new XYZ(CVmmToInt(x1), CVmmToInt(y[i]), 0);
                    XYZ end = new XYZ(CVmmToInt(x2), CVmmToInt(y[i]), 0);
                    //쐬
                    Autodesk.Revit.DB.Line line = Autodesk.Revit.DB.Line.CreateBound(start, end);
                    //Obhiʐcj쐬
                    Autodesk.Revit.DB.Grid grid = Autodesk.Revit.DB.Grid.Create(doc, line);
                    //Obhiʐcjɖ̂ݒ
                    grid.Name = symbolY[i];
                    //Xgɒǉ
                    gridY.Add(grid);
                }
                tx.Commit();
                //@̍쐬
                tx.Start("Transaction Create Dimensions");
                // XObh@̍쐬
                for (int i = 1; i < x.Length; i++)
                {
                    //@쐬ɂReferenceArrayKvBǂƂǂ̃Obh𐡖@ŌԂw肷
                    ReferenceArray references = new ReferenceArray();
                    references.Append(new Reference(gridX[i - 1]));
                    references.Append(new Reference(gridX[i]));
                    //@̈ʒu߂邽߂̃ItZbglBX500mmړ_ɐݒ
                    double offset = CVmmToInt(500);
                    //@̊Jn_ƏI_XYZW쐬
                    XYZ dimLineStart = new XYZ(gridX[i - 1].Curve.GetEndPoint(0).X, gridX[i - 1].Curve.GetEndPoint(0).Y + offset, 0);
                    XYZ dimLineEnd = new XYZ(gridX[i].Curve.GetEndPoint(0).X, gridX[i].Curve.GetEndPoint(0).Y + offset, 0);
                    //@ɂȂ쐬
                    Autodesk.Revit.DB.Line dimLine = Autodesk.Revit.DB.Line.CreateBound(dimLineStart, dimLineEnd);
                    //@쐬
                    doc.Create.NewDimension(activeView, dimLine, references);
                }
                // YObh@̍쐬
                for (int i = 1; i < y.Length; i++)
                {
                    ReferenceArray references = new ReferenceArray();
                    references.Append(new Reference(gridY[i - 1]));
                    references.Append(new Reference(gridY[i]));
                    double offset = CVmmToInt(500);
                    XYZ dimLineStart = new XYZ(gridY[i - 1].Curve.GetEndPoint(0).X + offset, gridY[i - 1].Curve.GetEndPoint(0).Y, 0);
                    XYZ dimLineEnd = new XYZ(gridY[i].Curve.GetEndPoint(0).X + offset, gridY[i].Curve.GetEndPoint(0).Y, 0);
                    Autodesk.Revit.DB.Line dimLine = Autodesk.Revit.DB.Line.CreateBound(dimLineStart, dimLineEnd);
                    doc.Create.NewDimension(activeView, dimLine, references);
                }
                tx.Commit();
            }
            return Result.Succeeded;
        }
        //~[^[Pʂɕϊ
        public static double CVmmToInt(double x)
        {
            return UnitUtils.ConvertToInternalUnits(x, UnitTypeId.Millimeters);
        }
    }
}
