#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Windows.Media;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Structure;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;

#endregion

namespace RevitAddinCreateColumn
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;

            //*****************
            //t@~
            string columnFamilyName = "p";
            //^Cv
            string columnTypeName = "600 x 600mm";
            //̈ʒuݒ
            XYZ[] columnPositions = new XYZ[]
            {
                new XYZ(0, 0, 0),
                new XYZ(Uni(7200), 0, 0),
                new XYZ(Uni(7200), Uni(7200), 0),
                new XYZ(0, Uni(7200), 0)
            };
            //̏㕔x
            string levelName = "x 3";

            //݊JĂ镽ʃr[̃x擾
            Level level = null;
            View activeView = uidoc.ActiveView;
            //ʃr[H
            if (activeView is ViewPlan viewPlan)
            {
                // ʃr[̃x擾
                level = doc.GetElement(viewPlan.GenLevel.Id) as Level;
            }
            else
            {
                TaskDialog.Show("G[", "݂̃r[͕ʃr[ł͂܂B");
                return Result.Failed;
            }

            //t@~ƃ^CvĎ擾
            FamilySymbol columnType = null;
            try
            {
                //vWFNgɓo^ĂLɑΉt@~ƃ^CviV{jĎ擾
                //t@~
                Family columnFamily = new FilteredElementCollector(doc).OfClass(typeof(Family)).FirstOrDefault(q => q.Name == columnFamilyName) as Family;
                if (columnFamily != null)
                {
                    //^Cv
                    columnType = columnFamily.GetFamilySymbolIds().Select(q => doc.GetElement(q)).First(q => q.Name == columnTypeName) as FamilySymbol;
                }
                else
                {
                    TaskDialog.Show("G[", $"w肳ꂽt@~ '{columnFamilyName}' ܂B");
                    return Result.Failed;
                }
                //㕔x
                Level topLevel = new FilteredElementCollector(doc).OfClass(typeof(Level)).FirstOrDefault(q => q.Name == levelName) as Level;
                if (topLevel == null)
                {
                    TaskDialog.Show("G[", $"w肳ꂽ㕔x '{levelName}' ܂B");
                    return Result.Failed;
                }
                //zu
                if (columnType != null && level != null)
                {
                    using (Transaction tx = new Transaction(doc))
                    {
                        tx.Start("Create Column");
                        //̔zu
                        foreach (XYZ pos in columnPositions)
                        {
                            //^CvANeBuȂANeBuɂ
                            if (!columnType.IsActive) columnType.Activate();
                            //zu
                            FamilyInstance column = doc.Create.NewFamilyInstance(pos, columnType, level, StructuralType.NonStructural);
                            //u㕔xvp[^ύX
                            column.get_Parameter(BuiltInParameter.FAMILY_TOP_LEVEL_PARAM).Set(topLevel.Id);
                        }
                        tx.Commit();
                    }
                }
            }
            catch (Exception ex)
            {
                // Oꍇ̃G[bZ[W
                TaskDialog.Show("G[", $"w肳ꂽ^Cv '{columnTypeName}' ܂BG[bZ[WF{ex.Message}");
                return Result.Failed;
            }

            return Result.Succeeded;
        }
        //~[gPʂPʂɕϊ
        private double Uni(double x)
        {
            return UnitUtils.ConvertToInternalUnits(x, UnitTypeId.Millimeters);
        }
    }
}
