#region Namespaces
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Architecture;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using System;
using System.Collections.Generic;
using System.Diagnostics;

#endregion

namespace RevitAddinCreateCeiling
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;
            View activeView = uidoc.ActiveView;
            //Ṽ^Cv
            string ceilingTypeName = "Obh 600x600mm";
            //V䍂ݒ
            double ceilingHeight = 2800; //mm
            // V̍wi~[gPʂtB[gPʂɕϊj
            double ceilingHeightFt = UnitUtils.ConvertToInternalUnits(ceilingHeight, UnitTypeId.Millimeters);
            //JĂ͕̂ʃr[H
            if (!(activeView is ViewPlan viewPlan))
            {
                TaskDialog.Show("G[", "݂̃r[͕ʃr[ł͂܂B");
                return Result.Failed;
            }
            // V^Cv擾
            CeilingType ceilingType = new FilteredElementCollector(doc)
                .OfClass(typeof(CeilingType))
                .Where(typ => typ.Name == ceilingTypeName)
                .First() as CeilingType;
            // Vzu镔RoomI
            Reference roomRef = uidoc.Selection.PickObject(
                ObjectType.Element,
                new RoomSelectionFilter(doc),
                "V쐬RoomIĂ");
            Room room = doc.GetElement(roomRef) as Room;
            if (room == null)
            {
                message = "IꂽvfRoomł͂܂B";
                return Result.Failed;
            }
            // Room̋E擾
            SpatialElementBoundaryOptions options = new SpatialElementBoundaryOptions();
            IList<IList<BoundarySegment>> boundaries = room.GetBoundarySegments(options);
            if (boundaries == null || boundaries.Count == 0)
            {
                message = "Room̋E擾ł܂B";
                return Result.Failed;
            }
            // Room̋EV̗֊spCurveLoop쐬
            CurveLoop curveLoop = new CurveLoop();
            foreach (BoundarySegment segment in boundaries[0])
            {
                curveLoop.Append(segment.GetCurve());
            }
            try
            {
                if (ceilingType != null)
                {
                    // gUNVJn
                    using (Transaction tx = new Transaction(doc))
                    {
                        tx.Start("Create Ceiling");
                        // V쐬
                        Ceiling ceiling = Ceiling.Create(
                            doc,
                            new CurveLoop[] { curveLoop },
                            ceilingType.Id,
                            room.Level.Id);
                        if (ceiling != null)//V䂪ɍ쐬ꂽꍇ
                        {
                            // V̍ItZbgݒ
                            Parameter heightOffsetParam = ceiling.get_Parameter(BuiltInParameter.CEILING_HEIGHTABOVELEVEL_PARAM);
                            if (heightOffsetParam != null && !heightOffsetParam.IsReadOnly)
                            {
                                heightOffsetParam.Set(ceilingHeightFt);
                            }
                            tx.Commit();
                            TaskDialog.Show("", $"Room '{room.Name}' ɍ{ceilingHeight}̓V𐳏ɍ쐬܂B");
                        }
                    }
                }
                else
                {
                    TaskDialog.Show("G[", "V^Cv܂B");
                    return Result.Failed;
                }
            }
            catch (System.Exception ex)
            {
                TaskDialog.Show("G[", $"V̍쐬Ɏs܂BG[bZ[WF{ex.Message}");
                return Result.Failed;
            }
            return Result.Succeeded;
        }
    }
    // RoomIp̃tB^[
    public class RoomSelectionFilter : ISelectionFilter
    {
        private readonly Document doc;
        //RXgN^
        public RoomSelectionFilter(Document doc)
        {
            this.doc = doc;
        }
        //vf̑I邩ǂ̃\bh
        public bool AllowElement(Element elem)
        {
            return elem is Room;
        }
        //vf̖ʂGbWȂǃWIgւ̎QƂIł邩ǂ̃\bh
        public bool AllowReference(Reference reference, XYZ position)
        {
            return false;
        }
    }
}
