#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Windows.Shapes;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Structure;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;

#endregion

namespace RevitAddinCreateBeam
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;

            //*****************
            // t@~
            string beamFamilyName = "RN[g-`";//"Ch tW`|"
            // ^Cv
            string beamTypeName = "300 x 600mm";//"H600x200x11x17"
            // ̊Ԋu
            double spanX = 3600;
            // ̐
            int beamCount = 10;
            // ŏ̗̈ʒuݒ
            double firstBeamStartX = 0;
            double firstStartBeamY = 0;
            double firstStartBeamZ = 4000;//xQ̍ɐݒBw肷Kv
            double firstBeamEndX = firstBeamStartX;
            double firstEndBeamY = firstStartBeamY + 14400;
            double firstEndBeamZ = firstStartBeamZ;
            // ̎n_ʒuƏI_ʒu
            double startX = firstBeamStartX; startX = UnitUtils.ConvertToInternalUnits(startX, UnitTypeId.Millimeters);
            double startY = firstStartBeamY; startY = UnitUtils.ConvertToInternalUnits(startY, UnitTypeId.Millimeters);
            double startZ = firstStartBeamZ; startZ = UnitUtils.ConvertToInternalUnits(startZ, UnitTypeId.Millimeters);
            XYZ start = new XYZ(startX, startY, startZ);
            double endX = firstBeamEndX; endX = UnitUtils.ConvertToInternalUnits(endX, UnitTypeId.Millimeters);
            double endY = firstEndBeamY; endY = UnitUtils.ConvertToInternalUnits(endY, UnitTypeId.Millimeters);
            double endZ = firstEndBeamZ; endZ = UnitUtils.ConvertToInternalUnits(endZ, UnitTypeId.Millimeters);
            XYZ end = new XYZ(endX, endY, endZ);
            // ̒Line
            Autodesk.Revit.DB.Line line = Autodesk.Revit.DB.Line.CreateBound(start, end);
            // ̗̒i[郊Xg
            IList<Curve> lines = new List<Curve>();
            // ̎wԊuŎw萔̒쐬
            spanX = UnitUtils.ConvertToInternalUnits(spanX, UnitTypeId.Millimeters);
            for (int i = 0; i < beamCount; i++)
            {
                // XgɊi[
                lines.Add(line);
                // wԊuړĎ̗̒쐬
                start = start.Add(new(spanX, 0, 0));
                end = end.Add(new(spanX, 0, 0));
                line = Autodesk.Revit.DB.Line.CreateBound(start, end);
            }            
            //݊JĂ镽ʃr[̃x擾
            Level level = null;
            View activeView = uidoc.ActiveView;
            //ʃr[H
            if (activeView is ViewPlan viewPlan)
            {
                // ʃr[̃x擾
                level = doc.GetElement(viewPlan.GenLevel.Id) as Level;
            }
            else
            {
                TaskDialog.Show("G[", "݂̃r[͕ʃr[ł͂܂B");
                return Result.Failed;
            }

            //t@~ƃ^CvĎ擾
            FamilySymbol beamType = null;
            try
            {
                //vWFNgɓo^ĂLɑΉt@~ƃ^CviV{jĎ擾
                //t@~
                Family beamFamily = new FilteredElementCollector(doc).OfClass(typeof(Family)).FirstOrDefault(q => q.Name == beamFamilyName) as Family;
                if (beamFamily != null)
                {
                    //^Cv
                    beamType = beamFamily.GetFamilySymbolIds().Select(q => doc.GetElement(q)).First(q => q.Name == beamTypeName) as FamilySymbol;
                }
                else
                {
                    TaskDialog.Show("G[", $"w肳ꂽt@~ '{beamFamilyName}' ܂B");
                    return Result.Failed;
                }
                //zu
                if (beamType != null && level != null)
                {
                    using (Transaction tx = new Transaction(doc))
                    {
                        tx.Start("Create Beam");
                        //̔zu
                        //^CvANeBuȂANeBuɂ
                        if (!beamType.IsActive) beamType.Activate();
                        //zu
                        foreach (var item in lines)
                        {
                            // zu@level͎w肵Ăݒuɂ͉eȂ͗lBnullł悢B̍͐ZWŌ܂B
                            FamilyInstance beam = doc.Create.NewFamilyInstance(item, beamType, level, StructuralType.Beam);
                        }
                        tx.Commit();
                    }
                }
            }
            catch (Exception ex)
            {
                // Oꍇ̃G[bZ[W
                TaskDialog.Show("G[", $"̍쐬Ɏs܂BG[bZ[WF{ex.Message}");
                return Result.Failed;
            }
            return Result.Succeeded;
        }
        //~[gPʂPʂɕϊ
        private double Uni(double x)
        {
            return UnitUtils.ConvertToInternalUnits(x, UnitTypeId.Millimeters);
        }
    }
}
