#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;

#endregion

namespace RevitAddinChangeWallType
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;

            // ItB^[ݒ
            WallSelectionFilter filter = new WallSelectionFilter(doc);

            try
            {
                // tB^[tŃ[U[ɕǃCX^XIĂ炤
                Reference myRef = uidoc.Selection.PickObject(ObjectType.Element, filter, "ǂIĂBLZɂESC܂");

                // Iꂽvf擾
                Element selectElement = doc.GetElement(myRef);
                // t@~A^CvAJeS擾
                Wall wall = selectElement as Wall;

                //ǃ^Cv
                string newWallTypeName = "(L#)EB1/EB1";
                WallType newWallType = new FilteredElementCollector(doc)
                    .OfClass(typeof(WallType))
                    .Where(typ => typ.Name == newWallTypeName).First() as WallType;

                if (newWallType != null)
                {
                    using (Transaction tx = new Transaction(doc, "Change Wall Type"))
                    {
                        tx.Start();
                        // ǂ̃^CvύX
                        wall.ChangeTypeId(newWallType.Id);
                        tx.Commit();
                    }
                }
                else
                {
                    // ǃ^CvȂꍇ̃G[bZ[W
                    TaskDialog.Show("G[", $"w肳ꂽǃ^Cv '{newWallTypeName}' ܂B");
                    return Result.Cancelled;
                }
            }
            catch (Autodesk.Revit.Exceptions.OperationCanceledException)
            {
                // [U[LZꍇ
                return Result.Cancelled;
            }
            catch (Exception ex)
            {
                // ̑̃G[ꍇ
                message = $"G[܂: {ex.Message}";
                return Result.Failed;
            }
            return Result.Succeeded;

        }
    }
    public class WallSelectionFilter : ISelectionFilter
    {
        private readonly Document doc;
        //RXgN^
        public WallSelectionFilter(Document doc)
        {
            this.doc = doc;
        }
        //vf̑I邩ǂ̃\bh
        public bool AllowElement(Element elem)
        {
            if (elem is Autodesk.Revit.DB.Wall)
            {
                return true;
            }
            return false;
        }
        //vf̖ʂGbWȂǃWIgւ̎QƂIł邩ǂ̃\bh
        public bool AllowReference(Reference reference, XYZ position)
        {
            return false;
        }
    }

}
