#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;

#endregion

namespace RevitAddinChangeWallProps
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;

            // ItB^[ݒ
            WallSelectionFilter filter = new WallSelectionFilter(doc);

            try
            {
                // tB^[tŃ[U[ɕǃCX^XIĂ炤
                Reference myRef = uidoc.Selection.PickObject(ObjectType.Element, filter, "ǂIĂBLZɂESC܂");

                // Iꂽvf擾
                Element selectElement = doc.GetElement(myRef);
                // WallNX̃CX^XɃLXg
                Wall wall = selectElement as Wall;

                // ǂ㕔ɃA^b`Ă邩
                Parameter isAttachedParam = wall.get_Parameter(BuiltInParameter.WALL_TOP_IS_ATTACHED);
                if (isAttachedParam.AsInteger() == 1)
                {
                    //㕔ɃA^b`Ăꍇ́AxoďI
                    // [U[ɏ㕔A^b`Ă炤
                    TaskDialog.Show("x", "̕ǂ͏㕔ɃA^b`ĂčύXł܂B㕔A^b`蓮ĂB");
                    return Result.Cancelled;
                }

                //݂̕ǂ̍擾
                Parameter heightParam = wall.get_Parameter(BuiltInParameter.WALL_USER_HEIGHT_PARAM);
                double currentHeight = heightParam.AsDouble();
                //Pʂ~[gɕϊ
                double currentHeightMM = (int)Math.Round(UnitUtils.ConvertFromInternalUnits(currentHeight, UnitTypeId.Millimeters), 0);
                // ύXǂ̏㕔ItZbgl
                double topOffsetMM = -1000;// 1000mm
                //Pʂɕϊ
                double topOffset = UnitUtils.ConvertToInternalUnits(topOffsetMM, UnitTypeId.Millimeters);
                //Vǂ̍PʂŌvZ
                double newHeight = currentHeight + topOffset;

                using (Transaction tx = new Transaction(doc, "Change Wall Height"))
                {
                    tx.Start();
                    //ǂ́u㕔xvp[^擾ĊmF
                    Parameter pm = wall.get_Parameter(BuiltInParameter.WALL_HEIGHT_TYPE);
                    //u㕔xṽp[^㕔̊Kł͂ȂuwvilInvalidElementIdjɂȂĂꍇ
                    if (pm.AsElementId() == ElementId.InvalidElementId)
                    {
                        //uw荂vp[^ύX
                        wall.get_Parameter(BuiltInParameter.WALL_USER_HEIGHT_PARAM).Set(newHeight);
                    }
                    else
                    {
                        //u㕔xṽp[^ꂩ㕔̊Kw肳Ăꍇ
                        //u㕔ItZbgvp[^ύX
                        wall.get_Parameter(BuiltInParameter.WALL_TOP_OFFSET).Set(topOffset);
                    }
                    tx.Commit();
                }
                TaskDialog.Show("Error", $"{currentHeightMM}mm{topOffsetMM}mmύX܂");
            }
            catch (Autodesk.Revit.Exceptions.OperationCanceledException)
            {
                // [U[LZꍇ
                return Result.Cancelled;
            }
            catch (Exception ex)
            {
                // ̑̃G[ꍇ
                message = $"G[܂: {ex.Message}";
                return Result.Failed;
            }
            return Result.Succeeded;
        }
    }
    public class WallSelectionFilter : ISelectionFilter
    {
        private readonly Document doc;
        //RXgN^
        public WallSelectionFilter(Document doc)
        {
            this.doc = doc;
        }
        //vf̑I邩ǂ̃\bh
        public bool AllowElement(Element elem)
        {
            if (elem is Autodesk.Revit.DB.Wall)
            {
                return true;
            }
            return false;
        }
        //vf̖ʂGbWȂǃWIgւ̎QƂIł邩ǂ̃\bh
        public bool AllowReference(Reference reference, XYZ position)
        {
            return false;
        }
    }
}
