﻿using Autodesk.Revit.UI;
using RevitAddinApplicationSample;
using System;
using System.Reflection;
using System.Windows.Media;

namespace RevitAddinApplicatinSample
{
    internal class RoomTagButton
    {
        public void Create(UIControlledApplication application)
        {
            string ribbonTabName = "MY ADDIN";
            string ribbonPanelName = "VIEW内タグ付け";
            string buttonName = "部屋タグ";
            try
            {
                application.CreateRibbonTab(ribbonTabName);//一番上のメニューのタブ
            }
            catch
            {

            }
            RibbonPanel ribbonPanel1 = (RibbonPanel)null;
            //指定したタブに既にリボンパネルが存在するか確認
            foreach (RibbonPanel ribbonPanel2 in application.GetRibbonPanels(ribbonTabName))
            {
                if (ribbonPanel2.Name == ribbonPanelName)
                {
                    //既にリボンパネルが存在する場合はそれを使用
                    ribbonPanel1 = ribbonPanel2;
                    break;
                }
            }
            if (ribbonPanel1 == null)
            {
                //リボンパネルが存在しない場合は新規作成
                ribbonPanel1 = application.CreateRibbonPanel(ribbonTabName, ribbonPanelName);
            }
            // 埋込リソースとして追加した画像を読み込む
            string manifestName = "RevitAddinApplicatinSample.Resources.roomTag.png";
            ImageSource imageSource = Extension.GetImageSourceFromManifest(Assembly.GetExecutingAssembly(), manifestName);
            string manifestName_small = "RevitAddinApplicatinSample.Resources.roomTag_small.png";
            ImageSource imageSource_small = Extension.GetImageSourceFromManifest(Assembly.GetExecutingAssembly(), manifestName_small);
            //PushButtonDataの作成
            PushButtonData pushButtonData1 = new PushButtonData("ROOM_TAG_BUTTON", buttonName, Assembly.GetExecutingAssembly().Location, "RevitAddinApplicatinSample.RoomTagExe");
            pushButtonData1.ToolTip = "部屋タグをつける";//ツールチップ
            pushButtonData1.LongDescription = "現在のビュー内にある部屋に対して部屋タグを付けます";//長い説明
            pushButtonData1.Image = imageSource_small;//画像
            pushButtonData1.LargeImage = imageSource;//大きい画像
            //ボタンをパネルに追加
            (ribbonPanel1.AddItem(pushButtonData1) as PushButton).Enabled = true;
        }
    }
}
