﻿using Autodesk.Revit.UI;
using RevitAddinApplicatinSample.Properties;
using RevitAddinApplicationSample;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Media;

namespace RevitAddinApplicatinSample
{
    internal class DoorTagButton
    {
        public void Create(UIControlledApplication application)
        {
            string ribbonTabName = "MY ADDIN";
            string ribbonPanelName = "VIEW内タグ付け";
            string buttonName = "ドアタグ";
            try
            {
                application.CreateRibbonTab(ribbonTabName);//一番上のメニューのタブ
            }
            catch
            {

            }
            RibbonPanel ribbonPanel1 = (RibbonPanel)null;
            //指定したタブに既にリボンパネルが存在するか確認
            foreach (RibbonPanel ribbonPanel2 in application.GetRibbonPanels(ribbonTabName))
            {
                if (ribbonPanel2.Name == ribbonPanelName)
                {
                    //既にリボンパネルが存在する場合はそれを使用
                    ribbonPanel1 = ribbonPanel2;
                    break;
                }
            }
            if (ribbonPanel1 == null)
            {
                //リボンパネルが存在しない場合は新規作成
                ribbonPanel1 = application.CreateRibbonPanel(ribbonTabName, ribbonPanelName);
            }
            // 埋込リソースとして追加した画像を読み込む
            string manifestName = "RevitAddinApplicatinSample.Resources.doorTag.png";
            ImageSource imageSource = Extension.GetImageSourceFromManifest(Assembly.GetExecutingAssembly(), manifestName);
            string manifestName_small = "RevitAddinApplicatinSample.Resources.doorTag_small.png";
            ImageSource imageSource_small = Extension.GetImageSourceFromManifest(Assembly.GetExecutingAssembly(), manifestName_small);
            PushButtonData pushButtonData1 = new PushButtonData("DOOR_TAG_BUTTON", buttonName, Assembly.GetExecutingAssembly().Location, "RevitAddinApplicatinSample.DoorTagExe");
            pushButtonData1.ToolTip = "ドアタグをつける";
            pushButtonData1.LongDescription = "現在のビュー内にあるドアに対してドアタグを付けます";
            pushButtonData1.Image = imageSource_small;
            pushButtonData1.LargeImage = imageSource;
            (ribbonPanel1.AddItem(pushButtonData1) as PushButton).Enabled = true;
        }
    }
}
