#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Diagnostics.Metrics;
using System.Windows.Input;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Architecture;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;

#endregion

namespace RevitAddinAllWalls
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;

            Dictionary<string, double> walls = new Dictionary<string, double>();

            //tB^[hGgRN^[Ńf̒̑SĂ̕ǂ𒊏o
            FilteredElementCollector col = new FilteredElementCollector(doc).OfClass(typeof(Wall));

            //̎擾
            string info = "ǂ̑: " + col.GetElementCount() + "\n";
            foreach (Wall wall in col)
            {
                //t@~A^Cv擾
                string fam = wall.WallType.FamilyName;
                string typ = wall.WallType.Name;
                // wallsfBNVĩL[̂߂ɕ쐬B"@"̓t@~ƃ^Cv𕪗邽ߋ؎q
                string wallFamilyAndType = fam + "@" + typ;

                //ǂ̖ʐς擾
                double area = wall.get_Parameter(BuiltInParameter.HOST_AREA_COMPUTED).AsDouble();
                //Pʂ𕽕[gɕϊ
                double areaSQM = Math.Round(UnitUtils.ConvertFromInternalUnits(area, UnitTypeId.SquareMeters), 2);

                // fBNViwalls̒ɃL[wallFamilyAndType݂邩mF
                if (walls.TryGetValue(wallFamilyAndType, out double areaCount))
                {
                    // ݂ꍇ͖ʐςZ
                    walls[wallFamilyAndType] = areaCount + areaSQM;
                }
                else
                {
                    walls.Add(wallFamilyAndType, areaSQM);
                }
            }
            // Dictionary̒g\            
            foreach (KeyValuePair<string, double> keyValue in walls)
            {
                //L[
                string key = keyValue.Key;
                //o[
                double v = keyValue.Value;

                //keyt@~ƃ^Cvɕ
                string[] k = key.Split("@");

                //infoɏǉ
                info += $"{k[0]} \t {k[1]} \t {v.ToString("F2")}\n";
            }
            // ʂ\
            TaskDialog.Show("ǂ̈ꗗ", $"{info}");

            return Result.Succeeded;
        }
    }
}
