#region Namespaces
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Architecture;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using System;
using System.Collections.Generic;
using System.Diagnostics;

#endregion

namespace RevitAddinAddRoomTags
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;
            View activeView = uidoc.ActiveView;

            //gp镔^O̐ݒ
            string tagFamily = "^O  ";
            string tagType = "O 1.5mm";

            //gp镔^O擾
            FamilySymbol desiredTag = new FilteredElementCollector(doc)
                    .OfClass(typeof(FamilySymbol))
                    .OfCategory(BuiltInCategory.OST_RoomTags)
                    .Cast<FamilySymbol>()
                    .Where(f => f.Family.Name == tagFamily &&
                    f.Name == tagType)
                    .First() as FamilySymbol;

            if (desiredTag == null)
            {
                string errorMessage = "ȉ̃t@~[hĂ܂B[hĂ炱̃AhCsĂB";
                errorMessage += $"\nt@~={tagFamily}: ^Cv:{tagType}";
                TaskDialog.Show("Error", errorMessage);
                return Result.Failed;
            }
            //^OΏۂ̕擾
            //ʐσ[̕͏OtB^[pӂ
            ParameterValueProvider areaProvider = new ParameterValueProvider(new ElementId(BuiltInParameter.ROOM_AREA));
            ElementParameterFilter areaFilter = new ElementParameterFilter(new FilterDoubleRule(areaProvider, new FilterNumericGreater(), 0, 0.0001));

            //activeView ̃x擾i݊JĂr[̃xj
            ElementId viewLevelId = activeView.GenLevel != null ? activeView.GenLevel.Id : ElementId.InvalidElementId;

            //݂̃r[̃xɂ镔擾Bʐσ[̕͏O
            var roomsOnLevel = new FilteredElementCollector(doc)
                .OfCategory(BuiltInCategory.OST_Rooms)
                .WherePasses(areaFilter)
                .Cast<Room>()
                .Where(room => room.LevelId == viewLevelId)
                .ToList();

            using (Transaction tx = new Transaction(doc))
            {
                tx.Start("Add room tag");
                foreach (Room room in roomsOnLevel)
                {
                    //^OtʒûRoom̈ʒu擾
                    LocationPoint cen = room.Location as LocationPoint;
                    if (cen != null)
                    {
                        //^ÖʒuRoom̒SƂBUVWnŎw肷
                        UV tagLocation = new UV(cen.Point.X, cen.Point.Y);
                        //^O쐬
                        LinkElementId roomId = new LinkElementId(room.Id);
                        RoomTag roomTag = doc.Create.NewRoomTag(roomId, tagLocation, activeView.Id);
                        //^Õ^CvύX
                        roomTag.ChangeTypeId(desiredTag.Id);
                    }
                }
                tx.Commit();
            }
            return Result.Succeeded;
        }
    }
}
