#region Namespaces
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Architecture;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using System;
using System.Collections.Generic;
using System.Diagnostics;

#endregion

namespace RevitAddinAddDoorTags
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;
            View activeView = uidoc.ActiveView;

            //gphA^O̐ݒ
            string tagFamily = "^O  hA";
            string tagType = "STD";

            //gphA^O擾
            FamilySymbol desiredTag = new FilteredElementCollector(doc)
                    .OfClass(typeof(FamilySymbol))
                    .OfCategory(BuiltInCategory.OST_DoorTags)
                    .Cast<FamilySymbol>()
                    .Where(f => f.Family.Name == tagFamily &&
                    f.Name == tagType)
                    .FirstOrDefault() as FamilySymbol;

            if (desiredTag == null)
            {
                string errorMessage = "ȉ̃t@~[hĂ܂B[hĂ炱̃AhCsĂB";
                errorMessage += $"\nt@~={tagFamily}: ^Cv:{tagType}";
                TaskDialog.Show("Error", errorMessage);
                return Result.Failed;
            }

            //activeView ̃x擾i݊JĂr[̃xj
            ElementId viewLevelId = activeView.GenLevel != null ? activeView.GenLevel.Id : ElementId.InvalidElementId;

            //݂̃r[̃xɂhA擾
            IList<FamilyInstance> doorsOnLevel = new FilteredElementCollector(doc)
                .OfClass(typeof(FamilyInstance))
                .OfCategory(BuiltInCategory.OST_Doors)
                .Cast<FamilyInstance>()
                .Where(door => door.LevelId == viewLevelId)
                .ToList();

            using (Transaction tx = new Transaction(doc))
            {
                tx.Start("Transaction Add Door Tag");

                //^O[h
                TagMode tagMode = TagMode.TM_ADDBY_CATEGORY;
                //^Ǒ
                TagOrientation tagorn = TagOrientation.Horizontal;

                foreach (FamilyInstance door in doorsOnLevel)
                {
                    //doorReference擾
                    Reference reference = new Reference(door);
                    //door̈ʒu擾
                    LocationPoint doorLocation = door.Location as LocationPoint;
                    //^Öʒu
                    XYZ tagLocation = new XYZ(doorLocation.Point.X, doorLocation.Point.Y, doorLocation.Point.Z);
                    //^O쐬
                    IndependentTag newTag = IndependentTag.Create(doc, activeView.Id, reference, true, tagMode, tagorn, tagLocation);
                    //hA^Õ^CvύX
                    newTag.ChangeTypeId(desiredTag.Id);

                    //o\
                    newTag.get_Parameter(BuiltInParameter.LEADER_LINE).Set(1);
                    //^Öʒu𒲐߂itB[gPʁj
                    XYZ headerPnt = tagLocation + new XYZ(4.0, 3.0, 0.0);
                    newTag.TagHeadPosition = headerPnt;
                    //õG{[ʒuݒ肷
                    newTag.LeaderEndCondition = LeaderEndCondition.Attached; //LeaderEndCondition.Free;
                    XYZ elbowPnt = tagLocation + new XYZ(1.0, 3.0, 0.0);
                    newTag.SetLeaderElbow(reference, elbowPnt);
                }
                tx.Commit();
            }
            return Result.Succeeded;
        }
    }
}
